// SPDX-License-Identifier: GPL-2.0
/*
 * SH7264 Pinmux
 *
 *  Copyright (C) 2012  Renesas Electronics Europe Ltd
 */

#include <linux/kernel.h>
#include <linux/gpio.h>
#include <cpu/sh7264.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	/* Port A */
	PA3_DATA, PA2_DATA, PA1_DATA, PA0_DATA,
	/* Port B */
	PB22_DATA, PB21_DATA, PB20_DATA,
	PB19_DATA, PB18_DATA, PB17_DATA, PB16_DATA,
	PB15_DATA, PB14_DATA, PB13_DATA, PB12_DATA,
	PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
	PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
	PB3_DATA, PB2_DATA, PB1_DATA,
	/* Port C */
	PC10_DATA, PC9_DATA, PC8_DATA,
	PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
	PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA,
	/* Port D */
	PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
	PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
	PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
	PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA,
	/* Port E */
	PE5_DATA, PE4_DATA,
	PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA,
	/* Port F */
	PF12_DATA,
	PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
	PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
	PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA,
	/* Port G */
	PG24_DATA,
	PG23_DATA, PG22_DATA, PG21_DATA, PG20_DATA,
	PG19_DATA, PG18_DATA, PG17_DATA, PG16_DATA,
	PG15_DATA, PG14_DATA, PG13_DATA, PG12_DATA,
	PG11_DATA, PG10_DATA, PG9_DATA, PG8_DATA,
	PG7_DATA, PG6_DATA, PG5_DATA, PG4_DATA,
	PG3_DATA, PG2_DATA, PG1_DATA, PG0_DATA,
	/* Port H */
	/* NOTE - Port H does not have a Data Register, but PH Data is
	   connected to PH Port Register */
	PH7_DATA, PH6_DATA, PH5_DATA, PH4_DATA,
	PH3_DATA, PH2_DATA, PH1_DATA, PH0_DATA,
	/* Port I - not on device */
	/* Port J */
	PJ12_DATA,
	PJ11_DATA, PJ10_DATA, PJ9_DATA, PJ8_DATA,
	PJ7_DATA, PJ6_DATA, PJ5_DATA, PJ4_DATA,
	PJ3_DATA, PJ2_DATA, PJ1_DATA, PJ0_DATA,
	/* Port K */
	PK12_DATA,
	PK11_DATA, PK10_DATA, PK9_DATA, PK8_DATA,
	PK7_DATA, PK6_DATA, PK5_DATA, PK4_DATA,
	PK3_DATA, PK2_DATA, PK1_DATA, PK0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	FORCE_IN,
	/* Port A */
	PA3_IN, PA2_IN, PA1_IN, PA0_IN,
	/* Port B */
	PB22_IN, PB21_IN, PB20_IN,
	PB19_IN, PB18_IN, PB17_IN, PB16_IN,
	PB15_IN, PB14_IN, PB13_IN, PB12_IN,
	PB11_IN, PB10_IN, PB9_IN, PB8_IN,
	PB7_IN, PB6_IN, PB5_IN, PB4_IN,
	PB3_IN, PB2_IN, PB1_IN,
	/* Port C */
	PC10_IN, PC9_IN, PC8_IN,
	PC7_IN, PC6_IN, PC5_IN, PC4_IN,
	PC3_IN, PC2_IN, PC1_IN, PC0_IN,
	/* Port D */
	PD15_IN, PD14_IN, PD13_IN, PD12_IN,
	PD11_IN, PD10_IN, PD9_IN, PD8_IN,
	PD7_IN, PD6_IN, PD5_IN, PD4_IN,
	PD3_IN, PD2_IN, PD1_IN, PD0_IN,
	/* Port E */
	PE5_IN, PE4_IN,
	PE3_IN, PE2_IN, PE1_IN, PE0_IN,
	/* Port F */
	PF12_IN,
	PF11_IN, PF10_IN, PF9_IN, PF8_IN,
	PF7_IN, PF6_IN, PF5_IN, PF4_IN,
	PF3_IN, PF2_IN, PF1_IN, PF0_IN,
	/* Port G */
	PG24_IN,
	PG23_IN, PG22_IN, PG21_IN, PG20_IN,
	PG19_IN, PG18_IN, PG17_IN, PG16_IN,
	PG15_IN, PG14_IN, PG13_IN, PG12_IN,
	PG11_IN, PG10_IN, PG9_IN, PG8_IN,
	PG7_IN, PG6_IN, PG5_IN, PG4_IN,
	PG3_IN, PG2_IN, PG1_IN, PG0_IN,
	/* Port H - Port H does not have a Data Register */
	/* Port I - not on device */
	/* Port J */
	PJ12_IN,
	PJ11_IN, PJ10_IN, PJ9_IN, PJ8_IN,
	PJ7_IN, PJ6_IN, PJ5_IN, PJ4_IN,
	PJ3_IN, PJ2_IN, PJ1_IN, PJ0_IN,
	/* Port K */
	PK12_IN,
	PK11_IN, PK10_IN, PK9_IN, PK8_IN,
	PK7_IN, PK6_IN, PK5_IN, PK4_IN,
	PK3_IN, PK2_IN, PK1_IN, PK0_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	FORCE_OUT,
	/* Port A */
	PA3_OUT, PA2_OUT, PA1_OUT, PA0_OUT,
	/* Port B */
	PB22_OUT, PB21_OUT, PB20_OUT,
	PB19_OUT, PB18_OUT, PB17_OUT, PB16_OUT,
	PB15_OUT, PB14_OUT, PB13_OUT, PB12_OUT,
	PB11_OUT, PB10_OUT, PB9_OUT, PB8_OUT,
	PB7_OUT, PB6_OUT, PB5_OUT, PB4_OUT,
	PB3_OUT, PB2_OUT, PB1_OUT,
	/* Port C */
	PC10_OUT, PC9_OUT, PC8_OUT,
	PC7_OUT, PC6_OUT, PC5_OUT, PC4_OUT,
	PC3_OUT, PC2_OUT, PC1_OUT, PC0_OUT,
	/* Port D */
	PD15_OUT, PD14_OUT, PD13_OUT, PD12_OUT,
	PD11_OUT, PD10_OUT, PD9_OUT, PD8_OUT,
	PD7_OUT, PD6_OUT, PD5_OUT, PD4_OUT,
	PD3_OUT, PD2_OUT, PD1_OUT, PD0_OUT,
	/* Port E */
	PE5_OUT, PE4_OUT,
	PE3_OUT, PE2_OUT, PE1_OUT, PE0_OUT,
	/* Port F */
	PF12_OUT,
	PF11_OUT, PF10_OUT, PF9_OUT, PF8_OUT,
	PF7_OUT, PF6_OUT, PF5_OUT, PF4_OUT,
	PF3_OUT, PF2_OUT, PF1_OUT, PF0_OUT,
	/* Port G */
	PG24_OUT,
	PG23_OUT, PG22_OUT, PG21_OUT, PG20_OUT,
	PG19_OUT, PG18_OUT, PG17_OUT, PG16_OUT,
	PG15_OUT, PG14_OUT, PG13_OUT, PG12_OUT,
	PG11_OUT, PG10_OUT, PG9_OUT, PG8_OUT,
	PG7_OUT, PG6_OUT, PG5_OUT, PG4_OUT,
	PG3_OUT, PG2_OUT, PG1_OUT, PG0_OUT,
	/* Port H - Port H does not have a Data Register */
	/* Port I - not on device */
	/* Port J */
	PJ12_OUT,
	PJ11_OUT, PJ10_OUT, PJ9_OUT, PJ8_OUT,
	PJ7_OUT, PJ6_OUT, PJ5_OUT, PJ4_OUT,
	PJ3_OUT, PJ2_OUT, PJ1_OUT, PJ0_OUT,
	/* Port K */
	PK12_OUT,
	PK11_OUT, PK10_OUT, PK9_OUT, PK8_OUT,
	PK7_OUT, PK6_OUT, PK5_OUT, PK4_OUT,
	PK3_OUT, PK2_OUT, PK1_OUT, PK0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_FUNCTION_BEGIN,
	/* Port A */
	PA3_IOR_IN, PA3_IOR_OUT,
	PA2_IOR_IN, PA2_IOR_OUT,
	PA1_IOR_IN, PA1_IOR_OUT,
	PA0_IOR_IN, PA0_IOR_OUT,

	/* Port B */
	PB11_IOR_IN, PB11_IOR_OUT,
	PB10_IOR_IN, PB10_IOR_OUT,
	PB9_IOR_IN, PB9_IOR_OUT,
	PB8_IOR_IN, PB8_IOR_OUT,

	PB22MD_00, PB22MD_01, PB22MD_10,
	PB21MD_0, PB21MD_1,
	PB20MD_0, PB20MD_1,
	PB19MD_00, PB19MD_01, PB19MD_10, PB19MD_11,
	PB18MD_00, PB18MD_01, PB18MD_10, PB18MD_11,
	PB17MD_00, PB17MD_01, PB17MD_10, PB17MD_11,
	PB16MD_00, PB16MD_01, PB16MD_10, PB16MD_11,
	PB15MD_00, PB15MD_01, PB15MD_10, PB15MD_11,
	PB14MD_00, PB14MD_01, PB14MD_10, PB14MD_11,
	PB13MD_00, PB13MD_01, PB13MD_10, PB13MD_11,
	PB12MD_00, PB12MD_01, PB12MD_10, PB12MD_11,
	PB11MD_00, PB11MD_01, PB11MD_10, PB11MD_11,
	PB10MD_00, PB10MD_01, PB10MD_10, PB10MD_11,
	PB9MD_00, PB9MD_01, PB9MD_10, PB9MD_11,
	PB8MD_00, PB8MD_01, PB8MD_10, PB8MD_11,
	PB7MD_00, PB7MD_01, PB7MD_10, PB7MD_11,
	PB6MD_00, PB6MD_01, PB6MD_10, PB6MD_11,
	PB5MD_00, PB5MD_01, PB5MD_10, PB5MD_11,
	PB4MD_00, PB4MD_01, PB4MD_10, PB4MD_11,
	PB3MD_0, PB3MD_1,
	PB2MD_0, PB2MD_1,
	PB1MD_0, PB1MD_1,

	/* Port C */
	PC14_IOR_IN, PC14_IOR_OUT,
	PC13_IOR_IN, PC13_IOR_OUT,
	PC12_IOR_IN, PC12_IOR_OUT,
	PC11_IOR_IN, PC11_IOR_OUT,
	PC10_IOR_IN, PC10_IOR_OUT,
	PC9_IOR_IN, PC9_IOR_OUT,
	PC8_IOR_IN, PC8_IOR_OUT,
	PC7_IOR_IN, PC7_IOR_OUT,
	PC6_IOR_IN, PC6_IOR_OUT,
	PC5_IOR_IN, PC5_IOR_OUT,
	PC4_IOR_IN, PC4_IOR_OUT,
	PC3_IOR_IN, PC3_IOR_OUT,
	PC2_IOR_IN, PC2_IOR_OUT,
	PC1_IOR_IN, PC1_IOR_OUT,
	PC0_IOR_IN, PC0_IOR_OUT,

	PC10MD_0, PC10MD_1,
	PC9MD_0, PC9MD_1,
	PC8MD_00, PC8MD_01, PC8MD_10, PC8MD_11,
	PC7MD_00, PC7MD_01, PC7MD_10, PC7MD_11,
	PC6MD_00, PC6MD_01, PC6MD_10, PC6MD_11,
	PC5MD_00, PC5MD_01, PC5MD_10, PC5MD_11,
	PC4MD_0, PC4MD_1,
	PC3MD_0, PC3MD_1,
	PC2MD_0, PC2MD_1,
	PC1MD_0, PC1MD_1,
	PC0MD_0, PC0MD_1,

	/* Port D */
	PD15_IOR_IN, PD15_IOR_OUT,
	PD14_IOR_IN, PD14_IOR_OUT,
	PD13_IOR_IN, PD13_IOR_OUT,
	PD12_IOR_IN, PD12_IOR_OUT,
	PD11_IOR_IN, PD11_IOR_OUT,
	PD10_IOR_IN, PD10_IOR_OUT,
	PD9_IOR_IN, PD9_IOR_OUT,
	PD8_IOR_IN, PD8_IOR_OUT,
	PD7_IOR_IN, PD7_IOR_OUT,
	PD6_IOR_IN, PD6_IOR_OUT,
	PD5_IOR_IN, PD5_IOR_OUT,
	PD4_IOR_IN, PD4_IOR_OUT,
	PD3_IOR_IN, PD3_IOR_OUT,
	PD2_IOR_IN, PD2_IOR_OUT,
	PD1_IOR_IN, PD1_IOR_OUT,
	PD0_IOR_IN, PD0_IOR_OUT,

	PD15MD_00, PD15MD_01, PD15MD_10, PD15MD_11,
	PD14MD_00, PD14MD_01, PD14MD_10, PD14MD_11,
	PD13MD_00, PD13MD_01, PD13MD_10, PD13MD_11,
	PD12MD_00, PD12MD_01, PD12MD_10, PD12MD_11,
	PD11MD_00, PD11MD_01, PD11MD_10, PD11MD_11,
	PD10MD_00, PD10MD_01, PD10MD_10, PD10MD_11,
	PD9MD_00, PD9MD_01, PD9MD_10, PD9MD_11,
	PD8MD_00, PD8MD_01, PD8MD_10, PD8MD_11,
	PD7MD_00, PD7MD_01, PD7MD_10, PD7MD_11,
	PD6MD_00, PD6MD_01, PD6MD_10, PD6MD_11,
	PD5MD_00, PD5MD_01, PD5MD_10, PD5MD_11,
	PD4MD_00, PD4MD_01, PD4MD_10, PD4MD_11,
	PD3MD_00, PD3MD_01, PD3MD_10, PD3MD_11,
	PD2MD_00, PD2MD_01, PD2MD_10, PD2MD_11,
	PD1MD_00, PD1MD_01, PD1MD_10, PD1MD_11,
	PD0MD_00, PD0MD_01, PD0MD_10, PD0MD_11,

	/* Port E */
	PE5_IOR_IN, PE5_IOR_OUT,
	PE4_IOR_IN, PE4_IOR_OUT,
	PE3_IOR_IN, PE3_IOR_OUT,
	PE2_IOR_IN, PE2_IOR_OUT,
	PE1_IOR_IN, PE1_IOR_OUT,
	PE0_IOR_IN, PE0_IOR_OUT,

	PE5MD_00, PE5MD_01, PE5MD_10, PE5MD_11,
	PE4MD_00, PE4MD_01, PE4MD_10, PE4MD_11,
	PE3MD_00, PE3MD_01, PE3MD_10, PE3MD_11,
	PE2MD_00, PE2MD_01, PE2MD_10, PE2MD_11,
	PE1MD_000, PE1MD_001, PE1MD_010, PE1MD_011,
	PE1MD_100, PE1MD_101, PE1MD_110, PE1MD_111,
	PE0MD_00, PE0MD_01, PE0MD_10, PE0MD_11,

	/* Port F */
	PF12_IOR_IN, PF12_IOR_OUT,
	PF11_IOR_IN, PF11_IOR_OUT,
	PF10_IOR_IN, PF10_IOR_OUT,
	PF9_IOR_IN, PF9_IOR_OUT,
	PF8_IOR_IN, PF8_IOR_OUT,
	PF7_IOR_IN, PF7_IOR_OUT,
	PF6_IOR_IN, PF6_IOR_OUT,
	PF5_IOR_IN, PF5_IOR_OUT,
	PF4_IOR_IN, PF4_IOR_OUT,
	PF3_IOR_IN, PF3_IOR_OUT,
	PF2_IOR_IN, PF2_IOR_OUT,
	PF1_IOR_IN, PF1_IOR_OUT,
	PF0_IOR_IN, PF0_IOR_OUT,

	PF12MD_000, PF12MD_001, PF12MD_010, PF12MD_011,
	PF12MD_100, PF12MD_101, PF12MD_110, PF12MD_111,
	PF11MD_000, PF11MD_001, PF11MD_010, PF11MD_011,
	PF11MD_100, PF11MD_101, PF11MD_110, PF11MD_111,
	PF10MD_000, PF10MD_001, PF10MD_010, PF10MD_011,
	PF10MD_100, PF10MD_101, PF10MD_110, PF10MD_111,
	PF9MD_000, PF9MD_001, PF9MD_010, PF9MD_011,
	PF9MD_100, PF9MD_101, PF9MD_110, PF9MD_111,
	PF8MD_00, PF8MD_01, PF8MD_10, PF8MD_11,
	PF7MD_000, PF7MD_001, PF7MD_010, PF7MD_011,
	PF7MD_100, PF7MD_101, PF7MD_110, PF7MD_111,
	PF6MD_000, PF6MD_001, PF6MD_010, PF6MD_011,
	PF6MD_100, PF6MD_101, PF6MD_110, PF6MD_111,
	PF5MD_000, PF5MD_001, PF5MD_010, PF5MD_011,
	PF5MD_100, PF5MD_101, PF5MD_110, PF5MD_111,
	PF4MD_000, PF4MD_001, PF4MD_010, PF4MD_011,
	PF4MD_100, PF4MD_101, PF4MD_110, PF4MD_111,
	PF3MD_000, PF3MD_001, PF3MD_010, PF3MD_011,
	PF3MD_100, PF3MD_101, PF3MD_110, PF3MD_111,
	PF2MD_000, PF2MD_001, PF2MD_010, PF2MD_011,
	PF2MD_100, PF2MD_101, PF2MD_110, PF2MD_111,
	PF1MD_000, PF1MD_001, PF1MD_010, PF1MD_011,
	PF1MD_100, PF1MD_101, PF1MD_110, PF1MD_111,
	PF0MD_000, PF0MD_001, PF0MD_010, PF0MD_011,
	PF0MD_100, PF0MD_101, PF0MD_110, PF0MD_111,

	/* Port G */
	PG24_IOR_IN, PG24_IOR_OUT,
	PG23_IOR_IN, PG23_IOR_OUT,
	PG22_IOR_IN, PG22_IOR_OUT,
	PG21_IOR_IN, PG21_IOR_OUT,
	PG20_IOR_IN, PG20_IOR_OUT,
	PG19_IOR_IN, PG19_IOR_OUT,
	PG18_IOR_IN, PG18_IOR_OUT,
	PG17_IOR_IN, PG17_IOR_OUT,
	PG16_IOR_IN, PG16_IOR_OUT,
	PG15_IOR_IN, PG15_IOR_OUT,
	PG14_IOR_IN, PG14_IOR_OUT,
	PG13_IOR_IN, PG13_IOR_OUT,
	PG12_IOR_IN, PG12_IOR_OUT,
	PG11_IOR_IN, PG11_IOR_OUT,
	PG10_IOR_IN, PG10_IOR_OUT,
	PG9_IOR_IN, PG9_IOR_OUT,
	PG8_IOR_IN, PG8_IOR_OUT,
	PG7_IOR_IN, PG7_IOR_OUT,
	PG6_IOR_IN, PG6_IOR_OUT,
	PG5_IOR_IN, PG5_IOR_OUT,
	PG4_IOR_IN, PG4_IOR_OUT,
	PG3_IOR_IN, PG3_IOR_OUT,
	PG2_IOR_IN, PG2_IOR_OUT,
	PG1_IOR_IN, PG1_IOR_OUT,
	PG0_IOR_IN, PG0_IOR_OUT,

	PG24MD_00, PG24MD_01, PG24MD_10, PG24MD_11,
	PG23MD_00, PG23MD_01, PG23MD_10, PG23MD_11,
	PG22MD_00, PG22MD_01, PG22MD_10, PG22MD_11,
	PG21MD_00, PG21MD_01, PG21MD_10, PG21MD_11,
	PG20MD_000, PG20MD_001, PG20MD_010, PG20MD_011,
	PG20MD_100, PG20MD_101, PG20MD_110, PG20MD_111,
	PG19MD_000, PG19MD_001, PG19MD_010, PG19MD_011,
	PG19MD_100, PG19MD_101, PG19MD_110, PG19MD_111,
	PG18MD_000, PG18MD_001, PG18MD_010, PG18MD_011,
	PG18MD_100, PG18MD_101, PG18MD_110, PG18MD_111,
	PG17MD_000, PG17MD_001, PG17MD_010, PG17MD_011,
	PG17MD_100, PG17MD_101, PG17MD_110, PG17MD_111,
	PG16MD_000, PG16MD_001, PG16MD_010, PG16MD_011,
	PG16MD_100, PG16MD_101, PG16MD_110, PG16MD_111,
	PG15MD_000, PG15MD_001, PG15MD_010, PG15MD_011,
	PG15MD_100, PG15MD_101, PG15MD_110, PG15MD_111,
	PG14MD_000, PG14MD_001, PG14MD_010, PG14MD_011,
	PG14MD_100, PG14MD_101, PG14MD_110, PG14MD_111,
	PG13MD_000, PG13MD_001, PG13MD_010, PG13MD_011,
	PG13MD_100, PG13MD_101, PG13MD_110, PG13MD_111,
	PG12MD_000, PG12MD_001, PG12MD_010, PG12MD_011,
	PG12MD_100, PG12MD_101, PG12MD_110, PG12MD_111,
	PG11MD_000, PG11MD_001, PG11MD_010, PG11MD_011,
	PG11MD_100, PG11MD_101, PG11MD_110, PG11MD_111,
	PG10MD_000, PG10MD_001, PG10MD_010, PG10MD_011,
	PG10MD_100, PG10MD_101, PG10MD_110, PG10MD_111,
	PG9MD_000, PG9MD_001, PG9MD_010, PG9MD_011,
	PG9MD_100, PG9MD_101, PG9MD_110, PG9MD_111,
	PG8MD_000, PG8MD_001, PG8MD_010, PG8MD_011,
	PG8MD_100, PG8MD_101, PG8MD_110, PG8MD_111,
	PG7MD_00, PG7MD_01, PG7MD_10, PG7MD_11,
	PG6MD_00, PG6MD_01, PG6MD_10, PG6MD_11,
	PG5MD_00, PG5MD_01, PG5MD_10, PG5MD_11,
	PG4MD_00, PG4MD_01, PG4MD_10, PG4MD_11,
	PG3MD_00, PG3MD_01, PG3MD_10, PG3MD_11,
	PG2MD_00, PG2MD_01, PG2MD_10, PG2MD_11,
	PG1MD_00, PG1MD_01, PG1MD_10, PG1MD_11,
	PG0MD_000, PG0MD_001, PG0MD_010, PG0MD_011,
	PG0MD_100, PG0MD_101, PG0MD_110, PG0MD_111,

	/* Port H */
	PH7MD_0, PH7MD_1,
	PH6MD_0, PH6MD_1,
	PH5MD_0, PH5MD_1,
	PH4MD_0, PH4MD_1,
	PH3MD_0, PH3MD_1,
	PH2MD_0, PH2MD_1,
	PH1MD_0, PH1MD_1,
	PH0MD_0, PH0MD_1,

	/* Port I - not on device */

	/* Port J */
	PJ11_IOR_IN, PJ11_IOR_OUT,
	PJ10_IOR_IN, PJ10_IOR_OUT,
	PJ9_IOR_IN, PJ9_IOR_OUT,
	PJ8_IOR_IN, PJ8_IOR_OUT,
	PJ7_IOR_IN, PJ7_IOR_OUT,
	PJ6_IOR_IN, PJ6_IOR_OUT,
	PJ5_IOR_IN, PJ5_IOR_OUT,
	PJ4_IOR_IN, PJ4_IOR_OUT,
	PJ3_IOR_IN, PJ3_IOR_OUT,
	PJ2_IOR_IN, PJ2_IOR_OUT,
	PJ1_IOR_IN, PJ1_IOR_OUT,
	PJ0_IOR_IN, PJ0_IOR_OUT,

	PJ11MD_00, PJ11MD_01, PJ11MD_10, PJ11MD_11,
	PJ10MD_00, PJ10MD_01, PJ10MD_10, PJ10MD_11,
	PJ9MD_00, PJ9MD_01, PJ9MD_10, PJ9MD_11,
	PJ8MD_00, PJ8MD_01, PJ8MD_10, PJ8MD_11,
	PJ7MD_00, PJ7MD_01, PJ7MD_10, PJ7MD_11,
	PJ6MD_00, PJ6MD_01, PJ6MD_10, PJ6MD_11,
	PJ5MD_00, PJ5MD_01, PJ5MD_10, PJ5MD_11,
	PJ4MD_00, PJ4MD_01, PJ4MD_10, PJ4MD_11,
	PJ3MD_00, PJ3MD_01, PJ3MD_10, PJ3MD_11,
	PJ2MD_000, PJ2MD_001, PJ2MD_010, PJ2MD_011,
	PJ2MD_100, PJ2MD_101, PJ2MD_110, PJ2MD_111,
	PJ1MD_000, PJ1MD_001, PJ1MD_010, PJ1MD_011,
	PJ1MD_100, PJ1MD_101, PJ1MD_110, PJ1MD_111,
	PJ0MD_000, PJ0MD_001, PJ0MD_010, PJ0MD_011,
	PJ0MD_100, PJ0MD_101, PJ0MD_110, PJ0MD_111,

	/* Port K */
	PK11_IOR_IN, PK11_IOR_OUT,
	PK10_IOR_IN, PK10_IOR_OUT,
	PK9_IOR_IN, PK9_IOR_OUT,
	PK8_IOR_IN, PK8_IOR_OUT,
	PK7_IOR_IN, PK7_IOR_OUT,
	PK6_IOR_IN, PK6_IOR_OUT,
	PK5_IOR_IN, PK5_IOR_OUT,
	PK4_IOR_IN, PK4_IOR_OUT,
	PK3_IOR_IN, PK3_IOR_OUT,
	PK2_IOR_IN, PK2_IOR_OUT,
	PK1_IOR_IN, PK1_IOR_OUT,
	PK0_IOR_IN, PK0_IOR_OUT,

	PK11MD_00, PK11MD_01, PK11MD_10, PK11MD_11,
	PK10MD_00, PK10MD_01, PK10MD_10, PK10MD_11,
	PK9MD_00, PK9MD_01, PK9MD_10, PK9MD_11,
	PK8MD_00, PK8MD_01, PK8MD_10, PK8MD_11,
	PK7MD_00, PK7MD_01, PK7MD_10, PK7MD_11,
	PK6MD_00, PK6MD_01, PK6MD_10, PK6MD_11,
	PK5MD_00, PK5MD_01, PK5MD_10, PK5MD_11,
	PK4MD_00, PK4MD_01, PK4MD_10, PK4MD_11,
	PK3MD_00, PK3MD_01, PK3MD_10, PK3MD_11,
	PK2MD_00, PK2MD_01, PK2MD_10, PK2MD_11,
	PK1MD_00, PK1MD_01, PK1MD_10, PK1MD_11,
	PK0MD_00, PK0MD_01, PK0MD_10, PK0MD_11,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,
	/* Port A */

	/* Port B */

	/* Port C */

	/* Port D */

	/* Port E */

	/* Port F */

	/* Port G */

	/* Port H */
	PHAN7_MARK, PHAN6_MARK, PHAN5_MARK, PHAN4_MARK,
	PHAN3_MARK, PHAN2_MARK, PHAN1_MARK, PHAN0_MARK,

	/* Port I - not on device */

	/* Port J */

	/* Port K */

	IRQ7_PC_MARK, IRQ6_PC_MARK, IRQ5_PC_MARK, IRQ4_PC_MARK,
	IRQ3_PG_MARK, IRQ2_PG_MARK, IRQ1_PJ_MARK, IRQ0_PJ_MARK,
	IRQ3_PE_MARK, IRQ2_PE_MARK, IRQ1_PE_MARK, IRQ0_PE_MARK,

	PINT7_PG_MARK, PINT6_PG_MARK, PINT5_PG_MARK, PINT4_PG_MARK,
	PINT3_PG_MARK, PINT2_PG_MARK, PINT1_PG_MARK, PINT0_PG_MARK,

	SD_CD_MARK, SD_D0_MARK, SD_D1_MARK, SD_D2_MARK, SD_D3_MARK,
	SD_WP_MARK, SD_CLK_MARK, SD_CMD_MARK,
	CRX0_MARK, CRX1_MARK,
	CTX0_MARK, CTX1_MARK,
	CRX0_CRX1_MARK, CTX0_CTX1_MARK,

	PWM1A_MARK, PWM1B_MARK, PWM1C_MARK, PWM1D_MARK,
	PWM1E_MARK, PWM1F_MARK, PWM1G_MARK, PWM1H_MARK,
	PWM2A_MARK, PWM2B_MARK, PWM2C_MARK, PWM2D_MARK,
	PWM2E_MARK, PWM2F_MARK, PWM2G_MARK, PWM2H_MARK,
	IERXD_MARK, IETXD_MARK,
	WDTOVF_MARK,

	/* DMAC */
	TEND0_MARK, DACK0_MARK, DREQ0_MARK,
	TEND1_MARK, DACK1_MARK, DREQ1_MARK,

	/* ADC */
	ADTRG_MARK,

	/* BSC */
	A25_MARK, A24_MARK,
	A23_MARK, A22_MARK, A21_MARK, A20_MARK,
	A19_MARK, A18_MARK, A17_MARK, A16_MARK,
	A15_MARK, A14_MARK, A13_MARK, A12_MARK,
	A11_MARK, A10_MARK, A9_MARK, A8_MARK,
	A7_MARK, A6_MARK, A5_MARK, A4_MARK,
	A3_MARK, A2_MARK, A1_MARK, A0_MARK,
	D15_MARK, D14_MARK, D13_MARK, D12_MARK,
	D11_MARK, D10_MARK, D9_MARK, D8_MARK,
	D7_MARK, D6_MARK, D5_MARK, D4_MARK,
	D3_MARK, D2_MARK, D1_MARK, D0_MARK,
	BS_MARK,
	CS4_MARK, CS3_MARK, CS2_MARK, CS1_MARK, CS0_MARK,
	CS6CE1B_MARK, CS5CE1A_MARK,
	CE2A_MARK, CE2B_MARK,
	RD_MARK, RDWR_MARK,
	ICIOWRAH_MARK,
	ICIORD_MARK,
	WE1DQMUWE_MARK,
	WE0DQML_MARK,
	RAS_MARK, CAS_MARK, CKE_MARK,
	WAIT_MARK, BREQ_MARK, BACK_MARK, IOIS16_MARK,

	/* TMU */
	TIOC0A_MARK, TIOC0B_MARK, TIOC0C_MARK, TIOC0D_MARK,
	TIOC1A_MARK, TIOC1B_MARK,
	TIOC2A_MARK, TIOC2B_MARK,
	TIOC3A_MARK, TIOC3B_MARK, TIOC3C_MARK, TIOC3D_MARK,
	TIOC4A_MARK, TIOC4B_MARK, TIOC4C_MARK, TIOC4D_MARK,
	TCLKA_MARK,	TCLKB_MARK, TCLKC_MARK, TCLKD_MARK,

	/* SCIF */
	SCK0_MARK, SCK1_MARK, SCK2_MARK, SCK3_MARK,
	RXD0_MARK, RXD1_MARK, RXD2_MARK, RXD3_MARK,
	TXD0_MARK, TXD1_MARK, TXD2_MARK, TXD3_MARK,
	RXD4_MARK, RXD5_MARK, RXD6_MARK, RXD7_MARK,
	TXD4_MARK, TXD5_MARK, TXD6_MARK, TXD7_MARK,
	RTS1_MARK, RTS3_MARK,
	CTS1_MARK, CTS3_MARK,

	/* RSPI */
	RSPCK0_MARK, RSPCK1_MARK,
	MOSI0_MARK, MOSI1_MARK,
	MISO0_PF12_MARK, MISO1_MARK, MISO1_PG19_MARK,
	SSL00_MARK, SSL10_MARK,

	/* IIC3 */
	SCL0_MARK, SCL1_MARK, SCL2_MARK,
	SDA0_MARK, SDA1_MARK, SDA2_MARK,

	/* SSI */
	SSISCK0_MARK,
	SSIWS0_MARK,
	SSITXD0_MARK,
	SSIRXD0_MARK,
	SSIWS1_MARK, SSIWS2_MARK, SSIWS3_MARK,
	SSISCK1_MARK, SSISCK2_MARK, SSISCK3_MARK,
	SSIDATA1_MARK, SSIDATA2_MARK, SSIDATA3_MARK,
	AUDIO_CLK_MARK,

	/* SIOF */ /* NOTE Shares AUDIO_CLK with SSI */
	SIOFTXD_MARK, SIOFRXD_MARK, SIOFSYNC_MARK, SIOFSCK_MARK,

	/* SPDIF */ /* NOTE Shares AUDIO_CLK with SSI */
	SPDIF_IN_MARK, SPDIF_OUT_MARK,

	/* NANDFMC */ /* NOTE Controller is not available in boot mode 0 */
	FCE_MARK,
	FRB_MARK,

	/* VDC3 */
	DV_CLK_MARK,
	DV_VSYNC_MARK, DV_HSYNC_MARK,
	DV_DATA7_MARK, DV_DATA6_MARK, DV_DATA5_MARK, DV_DATA4_MARK,
	DV_DATA3_MARK, DV_DATA2_MARK, DV_DATA1_MARK, DV_DATA0_MARK,
	LCD_CLK_MARK, LCD_EXTCLK_MARK,
	LCD_VSYNC_MARK, LCD_HSYNC_MARK, LCD_DE_MARK,
	LCD_DATA15_MARK, LCD_DATA14_MARK, LCD_DATA13_MARK, LCD_DATA12_MARK,
	LCD_DATA11_MARK, LCD_DATA10_MARK, LCD_DATA9_MARK, LCD_DATA8_MARK,
	LCD_DATA7_MARK, LCD_DATA6_MARK, LCD_DATA5_MARK, LCD_DATA4_MARK,
	LCD_DATA3_MARK, LCD_DATA2_MARK, LCD_DATA1_MARK, LCD_DATA0_MARK,
	LCD_M_DISP_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	/* Port A */
	PINMUX_DATA(PA3_DATA, PA3_IN),
	PINMUX_DATA(PA2_DATA, PA2_IN),
	PINMUX_DATA(PA1_DATA, PA1_IN),
	PINMUX_DATA(PA0_DATA, PA0_IN),

	/* Port B */
	PINMUX_DATA(PB22_DATA, PB22MD_00, PB22_IN, PB22_OUT),
	PINMUX_DATA(A22_MARK, PB22MD_01),
	PINMUX_DATA(CS4_MARK, PB22MD_10),

	PINMUX_DATA(PB21_DATA, PB21MD_0, PB21_IN, PB21_OUT),
	PINMUX_DATA(A21_MARK, PB21MD_1),
	PINMUX_DATA(A20_MARK, PB20MD_1),
	PINMUX_DATA(A19_MARK, PB19MD_01),
	PINMUX_DATA(A18_MARK, PB18MD_01),
	PINMUX_DATA(A17_MARK, PB17MD_01),
	PINMUX_DATA(A16_MARK, PB16MD_01),
	PINMUX_DATA(A15_MARK, PB15MD_01),
	PINMUX_DATA(A14_MARK, PB14MD_01),
	PINMUX_DATA(A13_MARK, PB13MD_01),
	PINMUX_DATA(A12_MARK, PB12MD_01),
	PINMUX_DATA(A11_MARK, PB11MD_01),
	PINMUX_DATA(A10_MARK, PB10MD_01),
	PINMUX_DATA(A9_MARK, PB9MD_01),
	PINMUX_DATA(A8_MARK, PB8MD_01),
	PINMUX_DATA(A7_MARK, PB7MD_01),
	PINMUX_DATA(A6_MARK, PB6MD_01),
	PINMUX_DATA(A5_MARK, PB5MD_01),
	PINMUX_DATA(A4_MARK, PB4MD_01),
	PINMUX_DATA(A3_MARK, PB3MD_1),
	PINMUX_DATA(A2_MARK, PB2MD_1),
	PINMUX_DATA(A1_MARK, PB1MD_1),

	/* Port C */
	PINMUX_DATA(PC10_DATA, PC10MD_0),
	PINMUX_DATA(TIOC2B_MARK, PC1MD_1),
	PINMUX_DATA(PC9_DATA, PC9MD_0),
	PINMUX_DATA(TIOC2A_MARK, PC9MD_1),
	PINMUX_DATA(PC8_DATA, PC8MD_00),
	PINMUX_DATA(CS3_MARK, PC8MD_01),
	PINMUX_DATA(TIOC4D_MARK, PC8MD_10),
	PINMUX_DATA(IRQ7_PC_MARK, PC8MD_11),
	PINMUX_DATA(PC7_DATA, PC7MD_00),
	PINMUX_DATA(CKE_MARK, PC7MD_01),
	PINMUX_DATA(TIOC4C_MARK, PC7MD_10),
	PINMUX_DATA(IRQ6_PC_MARK, PC7MD_11),
	PINMUX_DATA(PC6_DATA, PC6MD_00),
	PINMUX_DATA(CAS_MARK, PC6MD_01),
	PINMUX_DATA(TIOC4B_MARK, PC6MD_10),
	PINMUX_DATA(IRQ5_PC_MARK, PC6MD_11),
	PINMUX_DATA(PC5_DATA, PC5MD_00),
	PINMUX_DATA(RAS_MARK, PC5MD_01),
	PINMUX_DATA(TIOC4A_MARK, PC5MD_10),
	PINMUX_DATA(IRQ4_PC_MARK, PC5MD_11),
	PINMUX_DATA(PC4_DATA, PC4MD_0),
	PINMUX_DATA(WE1DQMUWE_MARK, PC4MD_1),
	PINMUX_DATA(PC3_DATA, PC3MD_0),
	PINMUX_DATA(WE0DQML_MARK, PC3MD_1),
	PINMUX_DATA(PC2_DATA, PC2MD_0),
	PINMUX_DATA(RDWR_MARK, PC2MD_1),
	PINMUX_DATA(PC1_DATA, PC1MD_0),
	PINMUX_DATA(RD_MARK, PC1MD_1),
	PINMUX_DATA(PC0_DATA, PC0MD_0),
	PINMUX_DATA(CS0_MARK, PC0MD_1),

	/* Port D */
	PINMUX_DATA(D15_MARK, PD15MD_01),
	PINMUX_DATA(D14_MARK, PD14MD_01),
	PINMUX_DATA(D13_MARK, PD13MD_01),
	PINMUX_DATA(D12_MARK, PD12MD_01),
	PINMUX_DATA(D11_MARK, PD11MD_01),
	PINMUX_DATA(D10_MARK, PD10MD_01),
	PINMUX_DATA(D9_MARK, PD9MD_01),
	PINMUX_DATA(D8_MARK, PD8MD_01),
	PINMUX_DATA(D7_MARK, PD7MD_01),
	PINMUX_DATA(D6_MARK, PD6MD_01),
	PINMUX_DATA(D5_MARK, PD5MD_01),
	PINMUX_DATA(D4_MARK, PD4MD_01),
	PINMUX_DATA(D3_MARK, PD3MD_01),
	PINMUX_DATA(D2_MARK, PD2MD_01),
	PINMUX_DATA(D1_MARK, PD1MD_01),
	PINMUX_DATA(D0_MARK, PD0MD_01),

	/* Port E */
	PINMUX_DATA(PE5_DATA, PE5MD_00),
	PINMUX_DATA(SDA2_MARK, PE5MD_01),
	PINMUX_DATA(DV_HSYNC_MARK, PE5MD_11),

	PINMUX_DATA(PE4_DATA, PE4MD_00),
	PINMUX_DATA(SCL2_MARK, PE4MD_01),
	PINMUX_DATA(DV_VSYNC_MARK, PE4MD_11),

	PINMUX_DATA(PE3_DATA, PE3MD_00),
	PINMUX_DATA(SDA1_MARK, PE3MD_01),
	PINMUX_DATA(IRQ3_PE_MARK, PE3MD_11),

	PINMUX_DATA(PE2_DATA, PE2MD_00),
	PINMUX_DATA(SCL1_MARK, PE2MD_01),
	PINMUX_DATA(IRQ2_PE_MARK, PE2MD_11),

	PINMUX_DATA(PE1_DATA, PE1MD_000),
	PINMUX_DATA(SDA0_MARK, PE1MD_001),
	PINMUX_DATA(IOIS16_MARK, PE1MD_010),
	PINMUX_DATA(IRQ1_PE_MARK, PE1MD_011),
	PINMUX_DATA(TCLKA_MARK, PE1MD_100),
	PINMUX_DATA(ADTRG_MARK, PE1MD_101),

	PINMUX_DATA(PE0_DATA, PE0MD_00),
	PINMUX_DATA(SCL0_MARK, PE0MD_01),
	PINMUX_DATA(AUDIO_CLK_MARK, PE0MD_10),
	PINMUX_DATA(IRQ0_PE_MARK, PE0MD_11),

	/* Port F */
	PINMUX_DATA(PF12_DATA, PF12MD_000),
	PINMUX_DATA(BS_MARK, PF12MD_001),
	PINMUX_DATA(MISO0_PF12_MARK, PF12MD_011),
	PINMUX_DATA(TIOC3D_MARK, PF12MD_100),
	PINMUX_DATA(SPDIF_OUT_MARK, PF12MD_101),

	PINMUX_DATA(PF11_DATA, PF11MD_000),
	PINMUX_DATA(A25_MARK, PF11MD_001),
	PINMUX_DATA(SSIDATA3_MARK, PF11MD_010),
	PINMUX_DATA(MOSI0_MARK, PF11MD_011),
	PINMUX_DATA(TIOC3C_MARK, PF11MD_100),
	PINMUX_DATA(SPDIF_IN_MARK, PF11MD_101),

	PINMUX_DATA(PF10_DATA, PF10MD_000),
	PINMUX_DATA(A24_MARK, PF10MD_001),
	PINMUX_DATA(SSIWS3_MARK, PF10MD_010),
	PINMUX_DATA(SSL00_MARK, PF10MD_011),
	PINMUX_DATA(TIOC3B_MARK, PF10MD_100),
	PINMUX_DATA(FCE_MARK, PF10MD_101),

	PINMUX_DATA(PF9_DATA, PF9MD_000),
	PINMUX_DATA(A23_MARK, PF9MD_001),
	PINMUX_DATA(SSISCK3_MARK, PF9MD_010),
	PINMUX_DATA(RSPCK0_MARK, PF9MD_011),
	PINMUX_DATA(TIOC3A_MARK, PF9MD_100),
	PINMUX_DATA(FRB_MARK, PF9MD_101),

	PINMUX_DATA(PF8_DATA, PF8MD_00),
	PINMUX_DATA(CE2B_MARK, PF8MD_01),
	PINMUX_DATA(SSIDATA3_MARK, PF8MD_10),
	PINMUX_DATA(DV_CLK_MARK, PF8MD_11),

	PINMUX_DATA(PF7_DATA, PF7MD_000),
	PINMUX_DATA(CE2A_MARK, PF7MD_001),
	PINMUX_DATA(SSIWS3_MARK, PF7MD_010),
	PINMUX_DATA(DV_DATA7_MARK, PF7MD_011),
	PINMUX_DATA(TCLKD_MARK, PF7MD_100),

	PINMUX_DATA(PF6_DATA, PF6MD_000),
	PINMUX_DATA(CS6CE1B_MARK, PF6MD_001),
	PINMUX_DATA(SSISCK3_MARK, PF6MD_010),
	PINMUX_DATA(DV_DATA6_MARK, PF6MD_011),
	PINMUX_DATA(TCLKB_MARK, PF6MD_100),

	PINMUX_DATA(PF5_DATA, PF5MD_000),
	PINMUX_DATA(CS5CE1A_MARK, PF5MD_001),
	PINMUX_DATA(SSIDATA2_MARK, PF5MD_010),
	PINMUX_DATA(DV_DATA5_MARK, PF5MD_011),
	PINMUX_DATA(TCLKC_MARK, PF5MD_100),

	PINMUX_DATA(PF4_DATA, PF4MD_000),
	PINMUX_DATA(ICIOWRAH_MARK, PF4MD_001),
	PINMUX_DATA(SSIWS2_MARK, PF4MD_010),
	PINMUX_DATA(DV_DATA4_MARK, PF4MD_011),
	PINMUX_DATA(TXD3_MARK, PF4MD_100),

	PINMUX_DATA(PF3_DATA, PF3MD_000),
	PINMUX_DATA(ICIORD_MARK, PF3MD_001),
	PINMUX_DATA(SSISCK2_MARK, PF3MD_010),
	PINMUX_DATA(DV_DATA3_MARK, PF3MD_011),
	PINMUX_DATA(RXD3_MARK, PF3MD_100),

	PINMUX_DATA(PF2_DATA, PF2MD_000),
	PINMUX_DATA(BACK_MARK, PF2MD_001),
	PINMUX_DATA(SSIDATA1_MARK, PF2MD_010),
	PINMUX_DATA(DV_DATA2_MARK, PF2MD_011),
	PINMUX_DATA(TXD2_MARK, PF2MD_100),
	PINMUX_DATA(DACK0_MARK, PF2MD_101),

	PINMUX_DATA(PF1_DATA, PF1MD_000),
	PINMUX_DATA(BREQ_MARK, PF1MD_001),
	PINMUX_DATA(SSIWS1_MARK, PF1MD_010),
	PINMUX_DATA(DV_DATA1_MARK, PF1MD_011),
	PINMUX_DATA(RXD2_MARK, PF1MD_100),
	PINMUX_DATA(DREQ0_MARK, PF1MD_101),

	PINMUX_DATA(PF0_DATA, PF0MD_000),
	PINMUX_DATA(WAIT_MARK, PF0MD_001),
	PINMUX_DATA(SSISCK1_MARK, PF0MD_010),
	PINMUX_DATA(DV_DATA0_MARK, PF0MD_011),
	PINMUX_DATA(SCK2_MARK, PF0MD_100),
	PINMUX_DATA(TEND0_MARK, PF0MD_101),

	/* Port G */
	PINMUX_DATA(PG24_DATA, PG24MD_00),
	PINMUX_DATA(MOSI0_MARK, PG24MD_01),
	PINMUX_DATA(TIOC0D_MARK, PG24MD_10),

	PINMUX_DATA(PG23_DATA, PG23MD_00),
	PINMUX_DATA(MOSI1_MARK, PG23MD_01),
	PINMUX_DATA(TIOC0C_MARK, PG23MD_10),

	PINMUX_DATA(PG22_DATA, PG22MD_00),
	PINMUX_DATA(SSL10_MARK, PG22MD_01),
	PINMUX_DATA(TIOC0B_MARK, PG22MD_10),

	PINMUX_DATA(PG21_DATA, PG21MD_00),
	PINMUX_DATA(RSPCK1_MARK, PG21MD_01),
	PINMUX_DATA(TIOC0A_MARK, PG21MD_10),

	PINMUX_DATA(PG20_DATA, PG20MD_000),
	PINMUX_DATA(LCD_EXTCLK_MARK, PG20MD_001),
	PINMUX_DATA(MISO1_MARK, PG20MD_011),
	PINMUX_DATA(TXD7_MARK, PG20MD_100),

	PINMUX_DATA(PG19_DATA, PG19MD_000),
	PINMUX_DATA(LCD_CLK_MARK, PG19MD_001),
	PINMUX_DATA(TIOC2B_MARK, PG19MD_010),
	PINMUX_DATA(MISO1_PG19_MARK, PG19MD_011),
	PINMUX_DATA(RXD7_MARK, PG19MD_100),

	PINMUX_DATA(PG18_DATA, PG18MD_000),
	PINMUX_DATA(LCD_DE_MARK, PG18MD_001),
	PINMUX_DATA(TIOC2A_MARK, PG18MD_010),
	PINMUX_DATA(SSL10_MARK, PG18MD_011),
	PINMUX_DATA(TXD6_MARK, PG18MD_100),

	PINMUX_DATA(PG17_DATA, PG17MD_000),
	PINMUX_DATA(LCD_HSYNC_MARK, PG17MD_001),
	PINMUX_DATA(TIOC1B_MARK, PG17MD_010),
	PINMUX_DATA(RSPCK1_MARK, PG17MD_011),
	PINMUX_DATA(RXD6_MARK, PG17MD_100),

	PINMUX_DATA(PG16_DATA, PG16MD_000),
	PINMUX_DATA(LCD_VSYNC_MARK, PG16MD_001),
	PINMUX_DATA(TIOC1A_MARK, PG16MD_010),
	PINMUX_DATA(TXD3_MARK, PG16MD_011),
	PINMUX_DATA(CTS1_MARK, PG16MD_100),

	PINMUX_DATA(PG15_DATA, PG15MD_000),
	PINMUX_DATA(LCD_DATA15_MARK, PG15MD_001),
	PINMUX_DATA(TIOC0D_MARK, PG15MD_010),
	PINMUX_DATA(RXD3_MARK, PG15MD_011),
	PINMUX_DATA(RTS1_MARK, PG15MD_100),

	PINMUX_DATA(PG14_DATA, PG14MD_000),
	PINMUX_DATA(LCD_DATA14_MARK, PG14MD_001),
	PINMUX_DATA(TIOC0C_MARK, PG14MD_010),
	PINMUX_DATA(SCK1_MARK, PG14MD_100),

	PINMUX_DATA(PG13_DATA, PG13MD_000),
	PINMUX_DATA(LCD_DATA13_MARK, PG13MD_001),
	PINMUX_DATA(TIOC0B_MARK, PG13MD_010),
	PINMUX_DATA(TXD1_MARK, PG13MD_100),

	PINMUX_DATA(PG12_DATA, PG12MD_000),
	PINMUX_DATA(LCD_DATA12_MARK, PG12MD_001),
	PINMUX_DATA(TIOC0A_MARK, PG12MD_010),
	PINMUX_DATA(RXD1_MARK, PG12MD_100),

	PINMUX_DATA(PG11_DATA, PG11MD_000),
	PINMUX_DATA(LCD_DATA11_MARK, PG11MD_001),
	PINMUX_DATA(SSITXD0_MARK, PG11MD_010),
	PINMUX_DATA(IRQ3_PG_MARK, PG11MD_011),
	PINMUX_DATA(TXD5_MARK, PG11MD_100),
	PINMUX_DATA(SIOFTXD_MARK, PG11MD_101),

	PINMUX_DATA(PG10_DATA, PG10MD_000),
	PINMUX_DATA(LCD_DATA10_MARK, PG10MD_001),
	PINMUX_DATA(SSIRXD0_MARK, PG10MD_010),
	PINMUX_DATA(IRQ2_PG_MARK, PG10MD_011),
	PINMUX_DATA(RXD5_MARK, PG10MD_100),
	PINMUX_DATA(SIOFRXD_MARK, PG10MD_101),

	PINMUX_DATA(PG9_DATA, PG9MD_000),
	PINMUX_DATA(LCD_DATA9_MARK, PG9MD_001),
	PINMUX_DATA(SSIWS0_MARK, PG9MD_010),
	PINMUX_DATA(TXD4_MARK, PG9MD_100),
	PINMUX_DATA(SIOFSYNC_MARK, PG9MD_101),

	PINMUX_DATA(PG8_DATA, PG8MD_000),
	PINMUX_DATA(LCD_DATA8_MARK, PG8MD_001),
	PINMUX_DATA(SSISCK0_MARK, PG8MD_010),
	PINMUX_DATA(RXD4_MARK, PG8MD_100),
	PINMUX_DATA(SIOFSCK_MARK, PG8MD_101),

	PINMUX_DATA(PG7_DATA, PG7MD_00),
	PINMUX_DATA(LCD_DATA7_MARK, PG7MD_01),
	PINMUX_DATA(SD_CD_MARK, PG7MD_10),
	PINMUX_DATA(PINT7_PG_MARK, PG7MD_11),

	PINMUX_DATA(PG6_DATA, PG7MD_00),
	PINMUX_DATA(LCD_DATA6_MARK, PG7MD_01),
	PINMUX_DATA(SD_WP_MARK, PG7MD_10),
	PINMUX_DATA(PINT6_PG_MARK, PG7MD_11),

	PINMUX_DATA(PG5_DATA, PG5MD_00),
	PINMUX_DATA(LCD_DATA5_MARK, PG5MD_01),
	PINMUX_DATA(SD_D1_MARK, PG5MD_10),
	PINMUX_DATA(PINT5_PG_MARK, PG5MD_11),

	PINMUX_DATA(PG4_DATA, PG4MD_00),
	PINMUX_DATA(LCD_DATA4_MARK, PG4MD_01),
	PINMUX_DATA(SD_D0_MARK, PG4MD_10),
	PINMUX_DATA(PINT4_PG_MARK, PG4MD_11),

	PINMUX_DATA(PG3_DATA, PG3MD_00),
	PINMUX_DATA(LCD_DATA3_MARK, PG3MD_01),
	PINMUX_DATA(SD_CLK_MARK, PG3MD_10),
	PINMUX_DATA(PINT3_PG_MARK, PG3MD_11),

	PINMUX_DATA(PG2_DATA, PG2MD_00),
	PINMUX_DATA(LCD_DATA2_MARK, PG2MD_01),
	PINMUX_DATA(SD_CMD_MARK, PG2MD_10),
	PINMUX_DATA(PINT2_PG_MARK, PG2MD_11),

	PINMUX_DATA(PG1_DATA, PG1MD_00),
	PINMUX_DATA(LCD_DATA1_MARK, PG1MD_01),
	PINMUX_DATA(SD_D3_MARK, PG1MD_10),
	PINMUX_DATA(PINT1_PG_MARK, PG1MD_11),

	PINMUX_DATA(PG0_DATA, PG0MD_000),
	PINMUX_DATA(LCD_DATA0_MARK, PG0MD_001),
	PINMUX_DATA(SD_D2_MARK, PG0MD_010),
	PINMUX_DATA(PINT0_PG_MARK, PG0MD_011),
	PINMUX_DATA(WDTOVF_MARK, PG0MD_100),

	/* Port H */
	PINMUX_DATA(PH7_DATA, PH7MD_0),
	PINMUX_DATA(PHAN7_MARK, PH7MD_1),

	PINMUX_DATA(PH6_DATA, PH6MD_0),
	PINMUX_DATA(PHAN6_MARK, PH6MD_1),

	PINMUX_DATA(PH5_DATA, PH5MD_0),
	PINMUX_DATA(PHAN5_MARK, PH5MD_1),

	PINMUX_DATA(PH4_DATA, PH4MD_0),
	PINMUX_DATA(PHAN4_MARK, PH4MD_1),

	PINMUX_DATA(PH3_DATA, PH3MD_0),
	PINMUX_DATA(PHAN3_MARK, PH3MD_1),

	PINMUX_DATA(PH2_DATA, PH2MD_0),
	PINMUX_DATA(PHAN2_MARK, PH2MD_1),

	PINMUX_DATA(PH1_DATA, PH1MD_0),
	PINMUX_DATA(PHAN1_MARK, PH1MD_1),

	PINMUX_DATA(PH0_DATA, PH0MD_0),
	PINMUX_DATA(PHAN0_MARK, PH0MD_1),

	/* Port I - not on device */

	/* Port J */
	PINMUX_DATA(PJ11_DATA, PJ11MD_00),
	PINMUX_DATA(PWM2H_MARK, PJ11MD_01),
	PINMUX_DATA(DACK1_MARK, PJ11MD_10),

	PINMUX_DATA(PJ10_DATA, PJ10MD_00),
	PINMUX_DATA(PWM2G_MARK, PJ10MD_01),
	PINMUX_DATA(DREQ1_MARK, PJ10MD_10),

	PINMUX_DATA(PJ9_DATA, PJ9MD_00),
	PINMUX_DATA(PWM2F_MARK, PJ9MD_01),
	PINMUX_DATA(TEND1_MARK, PJ9MD_10),

	PINMUX_DATA(PJ8_DATA, PJ8MD_00),
	PINMUX_DATA(PWM2E_MARK, PJ8MD_01),
	PINMUX_DATA(RTS3_MARK, PJ8MD_10),

	PINMUX_DATA(PJ7_DATA, PJ7MD_00),
	PINMUX_DATA(TIOC1B_MARK, PJ7MD_01),
	PINMUX_DATA(CTS3_MARK, PJ7MD_10),

	PINMUX_DATA(PJ6_DATA, PJ6MD_00),
	PINMUX_DATA(TIOC1A_MARK, PJ6MD_01),
	PINMUX_DATA(SCK3_MARK, PJ6MD_10),

	PINMUX_DATA(PJ5_DATA, PJ5MD_00),
	PINMUX_DATA(IERXD_MARK, PJ5MD_01),
	PINMUX_DATA(TXD3_MARK, PJ5MD_10),

	PINMUX_DATA(PJ4_DATA, PJ4MD_00),
	PINMUX_DATA(IETXD_MARK, PJ4MD_01),
	PINMUX_DATA(RXD3_MARK, PJ4MD_10),

	PINMUX_DATA(PJ3_DATA, PJ3MD_00),
	PINMUX_DATA(CRX1_MARK, PJ3MD_01),
	PINMUX_DATA(CRX0_CRX1_MARK, PJ3MD_10),
	PINMUX_DATA(IRQ1_PJ_MARK, PJ3MD_11),

	PINMUX_DATA(PJ2_DATA, PJ2MD_000),
	PINMUX_DATA(CTX1_MARK, PJ2MD_001),
	PINMUX_DATA(CTX0_CTX1_MARK, PJ2MD_010),
	PINMUX_DATA(CS2_MARK, PJ2MD_011),
	PINMUX_DATA(SCK0_MARK, PJ2MD_100),
	PINMUX_DATA(LCD_M_DISP_MARK, PJ2MD_101),

	PINMUX_DATA(PJ1_DATA, PJ1MD_000),
	PINMUX_DATA(CRX0_MARK, PJ1MD_001),
	PINMUX_DATA(IERXD_MARK, PJ1MD_010),
	PINMUX_DATA(IRQ0_PJ_MARK, PJ1MD_011),
	PINMUX_DATA(RXD0_MARK, PJ1MD_100),

	PINMUX_DATA(PJ0_DATA, PJ0MD_000),
	PINMUX_DATA(CTX0_MARK, PJ0MD_001),
	PINMUX_DATA(IERXD_MARK, PJ0MD_010),
	PINMUX_DATA(CS1_MARK, PJ0MD_011),
	PINMUX_DATA(TXD0_MARK, PJ0MD_100),
	PINMUX_DATA(A0_MARK, PJ0MD_101),

	/* Port K */
	PINMUX_DATA(PK11_DATA, PK11MD_00),
	PINMUX_DATA(PWM2D_MARK, PK11MD_01),
	PINMUX_DATA(SSITXD0_MARK, PK11MD_10),

	PINMUX_DATA(PK10_DATA, PK10MD_00),
	PINMUX_DATA(PWM2C_MARK, PK10MD_01),
	PINMUX_DATA(SSIRXD0_MARK, PK10MD_10),

	PINMUX_DATA(PK9_DATA, PK9MD_00),
	PINMUX_DATA(PWM2B_MARK, PK9MD_01),
	PINMUX_DATA(SSIWS0_MARK, PK9MD_10),

	PINMUX_DATA(PK8_DATA, PK8MD_00),
	PINMUX_DATA(PWM2A_MARK, PK8MD_01),
	PINMUX_DATA(SSISCK0_MARK, PK8MD_10),

	PINMUX_DATA(PK7_DATA, PK7MD_00),
	PINMUX_DATA(PWM1H_MARK, PK7MD_01),
	PINMUX_DATA(SD_CD_MARK, PK7MD_10),

	PINMUX_DATA(PK6_DATA, PK6MD_00),
	PINMUX_DATA(PWM1G_MARK, PK6MD_01),
	PINMUX_DATA(SD_WP_MARK, PK6MD_10),

	PINMUX_DATA(PK5_DATA, PK5MD_00),
	PINMUX_DATA(PWM1F_MARK, PK5MD_01),
	PINMUX_DATA(SD_D1_MARK, PK5MD_10),

	PINMUX_DATA(PK4_DATA, PK4MD_00),
	PINMUX_DATA(PWM1E_MARK, PK4MD_01),
	PINMUX_DATA(SD_D0_MARK, PK4MD_10),

	PINMUX_DATA(PK3_DATA, PK3MD_00),
	PINMUX_DATA(PWM1D_MARK, PK3MD_01),
	PINMUX_DATA(SD_CLK_MARK, PK3MD_10),

	PINMUX_DATA(PK2_DATA, PK2MD_00),
	PINMUX_DATA(PWM1C_MARK, PK2MD_01),
	PINMUX_DATA(SD_CMD_MARK, PK2MD_10),

	PINMUX_DATA(PK1_DATA, PK1MD_00),
	PINMUX_DATA(PWM1B_MARK, PK1MD_01),
	PINMUX_DATA(SD_D3_MARK, PK1MD_10),

	PINMUX_DATA(PK0_DATA, PK0MD_00),
	PINMUX_DATA(PWM1A_MARK, PK0MD_01),
	PINMUX_DATA(SD_D2_MARK, PK0MD_10),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	/* Port A */
	PINMUX_GPIO(PA3),
	PINMUX_GPIO(PA2),
	PINMUX_GPIO(PA1),
	PINMUX_GPIO(PA0),

	/* Port B */
	PINMUX_GPIO(PB22),
	PINMUX_GPIO(PB21),
	PINMUX_GPIO(PB20),
	PINMUX_GPIO(PB19),
	PINMUX_GPIO(PB18),
	PINMUX_GPIO(PB17),
	PINMUX_GPIO(PB16),
	PINMUX_GPIO(PB15),
	PINMUX_GPIO(PB14),
	PINMUX_GPIO(PB13),
	PINMUX_GPIO(PB12),
	PINMUX_GPIO(PB11),
	PINMUX_GPIO(PB10),
	PINMUX_GPIO(PB9),
	PINMUX_GPIO(PB8),
	PINMUX_GPIO(PB7),
	PINMUX_GPIO(PB6),
	PINMUX_GPIO(PB5),
	PINMUX_GPIO(PB4),
	PINMUX_GPIO(PB3),
	PINMUX_GPIO(PB2),
	PINMUX_GPIO(PB1),

	/* Port C */
	PINMUX_GPIO(PC10),
	PINMUX_GPIO(PC9),
	PINMUX_GPIO(PC8),
	PINMUX_GPIO(PC7),
	PINMUX_GPIO(PC6),
	PINMUX_GPIO(PC5),
	PINMUX_GPIO(PC4),
	PINMUX_GPIO(PC3),
	PINMUX_GPIO(PC2),
	PINMUX_GPIO(PC1),
	PINMUX_GPIO(PC0),

	/* Port D */
	PINMUX_GPIO(PD15),
	PINMUX_GPIO(PD14),
	PINMUX_GPIO(PD13),
	PINMUX_GPIO(PD12),
	PINMUX_GPIO(PD11),
	PINMUX_GPIO(PD10),
	PINMUX_GPIO(PD9),
	PINMUX_GPIO(PD8),
	PINMUX_GPIO(PD7),
	PINMUX_GPIO(PD6),
	PINMUX_GPIO(PD5),
	PINMUX_GPIO(PD4),
	PINMUX_GPIO(PD3),
	PINMUX_GPIO(PD2),
	PINMUX_GPIO(PD1),
	PINMUX_GPIO(PD0),

	/* Port E */
	PINMUX_GPIO(PE5),
	PINMUX_GPIO(PE4),
	PINMUX_GPIO(PE3),
	PINMUX_GPIO(PE2),
	PINMUX_GPIO(PE1),
	PINMUX_GPIO(PE0),

	/* Port F */
	PINMUX_GPIO(PF12),
	PINMUX_GPIO(PF11),
	PINMUX_GPIO(PF10),
	PINMUX_GPIO(PF9),
	PINMUX_GPIO(PF8),
	PINMUX_GPIO(PF7),
	PINMUX_GPIO(PF6),
	PINMUX_GPIO(PF5),
	PINMUX_GPIO(PF4),
	PINMUX_GPIO(PF3),
	PINMUX_GPIO(PF2),
	PINMUX_GPIO(PF1),
	PINMUX_GPIO(PF0),

	/* Port G */
	PINMUX_GPIO(PG24),
	PINMUX_GPIO(PG23),
	PINMUX_GPIO(PG22),
	PINMUX_GPIO(PG21),
	PINMUX_GPIO(PG20),
	PINMUX_GPIO(PG19),
	PINMUX_GPIO(PG18),
	PINMUX_GPIO(PG17),
	PINMUX_GPIO(PG16),
	PINMUX_GPIO(PG15),
	PINMUX_GPIO(PG14),
	PINMUX_GPIO(PG13),
	PINMUX_GPIO(PG12),
	PINMUX_GPIO(PG11),
	PINMUX_GPIO(PG10),
	PINMUX_GPIO(PG9),
	PINMUX_GPIO(PG8),
	PINMUX_GPIO(PG7),
	PINMUX_GPIO(PG6),
	PINMUX_GPIO(PG5),
	PINMUX_GPIO(PG4),
	PINMUX_GPIO(PG3),
	PINMUX_GPIO(PG2),
	PINMUX_GPIO(PG1),
	PINMUX_GPIO(PG0),

	/* Port H - Port H does not have a Data Register */

	/* Port I - not on device */

	/* Port J */
	PINMUX_GPIO(PJ11),
	PINMUX_GPIO(PJ10),
	PINMUX_GPIO(PJ9),
	PINMUX_GPIO(PJ8),
	PINMUX_GPIO(PJ7),
	PINMUX_GPIO(PJ6),
	PINMUX_GPIO(PJ5),
	PINMUX_GPIO(PJ4),
	PINMUX_GPIO(PJ3),
	PINMUX_GPIO(PJ2),
	PINMUX_GPIO(PJ1),
	PINMUX_GPIO(PJ0),

	/* Port K */
	PINMUX_GPIO(PK11),
	PINMUX_GPIO(PK10),
	PINMUX_GPIO(PK9),
	PINMUX_GPIO(PK8),
	PINMUX_GPIO(PK7),
	PINMUX_GPIO(PK6),
	PINMUX_GPIO(PK5),
	PINMUX_GPIO(PK4),
	PINMUX_GPIO(PK3),
	PINMUX_GPIO(PK2),
	PINMUX_GPIO(PK1),
	PINMUX_GPIO(PK0),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* INTC */
	GPIO_FN(PINT7_PG),
	GPIO_FN(PINT6_PG),
	GPIO_FN(PINT5_PG),
	GPIO_FN(PINT4_PG),
	GPIO_FN(PINT3_PG),
	GPIO_FN(PINT2_PG),
	GPIO_FN(PINT1_PG),

	GPIO_FN(IRQ7_PC),
	GPIO_FN(IRQ6_PC),
	GPIO_FN(IRQ5_PC),
	GPIO_FN(IRQ4_PC),
	GPIO_FN(IRQ3_PG),
	GPIO_FN(IRQ2_PG),
	GPIO_FN(IRQ1_PJ),
	GPIO_FN(IRQ0_PJ),
	GPIO_FN(IRQ3_PE),
	GPIO_FN(IRQ2_PE),
	GPIO_FN(IRQ1_PE),
	GPIO_FN(IRQ0_PE),

	/* WDT */
	GPIO_FN(WDTOVF),

	/* CAN */
	GPIO_FN(CTX1),
	GPIO_FN(CRX1),
	GPIO_FN(CTX0),
	GPIO_FN(CTX0_CTX1),
	GPIO_FN(CRX0),
	GPIO_FN(CRX0_CRX1),

	/* DMAC */
	GPIO_FN(TEND0),
	GPIO_FN(DACK0),
	GPIO_FN(DREQ0),
	GPIO_FN(TEND1),
	GPIO_FN(DACK1),
	GPIO_FN(DREQ1),

	/* ADC */
	GPIO_FN(ADTRG),

	/* BSCh */
	GPIO_FN(A25),
	GPIO_FN(A24),
	GPIO_FN(A23),
	GPIO_FN(A22),
	GPIO_FN(A21),
	GPIO_FN(A20),
	GPIO_FN(A19),
	GPIO_FN(A18),
	GPIO_FN(A17),
	GPIO_FN(A16),
	GPIO_FN(A15),
	GPIO_FN(A14),
	GPIO_FN(A13),
	GPIO_FN(A12),
	GPIO_FN(A11),
	GPIO_FN(A10),
	GPIO_FN(A9),
	GPIO_FN(A8),
	GPIO_FN(A7),
	GPIO_FN(A6),
	GPIO_FN(A5),
	GPIO_FN(A4),
	GPIO_FN(A3),
	GPIO_FN(A2),
	GPIO_FN(A1),
	GPIO_FN(A0),

	GPIO_FN(D15),
	GPIO_FN(D14),
	GPIO_FN(D13),
	GPIO_FN(D12),
	GPIO_FN(D11),
	GPIO_FN(D10),
	GPIO_FN(D9),
	GPIO_FN(D8),
	GPIO_FN(D7),
	GPIO_FN(D6),
	GPIO_FN(D5),
	GPIO_FN(D4),
	GPIO_FN(D3),
	GPIO_FN(D2),
	GPIO_FN(D1),
	GPIO_FN(D0),

	GPIO_FN(BS),
	GPIO_FN(CS4),
	GPIO_FN(CS3),
	GPIO_FN(CS2),
	GPIO_FN(CS1),
	GPIO_FN(CS0),
	GPIO_FN(CS6CE1B),
	GPIO_FN(CS5CE1A),
	GPIO_FN(CE2A),
	GPIO_FN(CE2B),
	GPIO_FN(RD),
	GPIO_FN(RDWR),
	GPIO_FN(ICIOWRAH),
	GPIO_FN(ICIORD),
	GPIO_FN(WE1DQMUWE),
	GPIO_FN(WE0DQML),
	GPIO_FN(RAS),
	GPIO_FN(CAS),
	GPIO_FN(CKE),
	GPIO_FN(WAIT),
	GPIO_FN(BREQ),
	GPIO_FN(BACK),
	GPIO_FN(IOIS16),

	/* TMU */
	GPIO_FN(TIOC4D),
	GPIO_FN(TIOC4C),
	GPIO_FN(TIOC4B),
	GPIO_FN(TIOC4A),
	GPIO_FN(TIOC3D),
	GPIO_FN(TIOC3C),
	GPIO_FN(TIOC3B),
	GPIO_FN(TIOC3A),
	GPIO_FN(TIOC2B),
	GPIO_FN(TIOC1B),
	GPIO_FN(TIOC2A),
	GPIO_FN(TIOC1A),
	GPIO_FN(TIOC0D),
	GPIO_FN(TIOC0C),
	GPIO_FN(TIOC0B),
	GPIO_FN(TIOC0A),
	GPIO_FN(TCLKD),
	GPIO_FN(TCLKC),
	GPIO_FN(TCLKB),
	GPIO_FN(TCLKA),

	/* SCIF */
	GPIO_FN(TXD0),
	GPIO_FN(RXD0),
	GPIO_FN(SCK0),
	GPIO_FN(TXD1),
	GPIO_FN(RXD1),
	GPIO_FN(SCK1),
	GPIO_FN(TXD2),
	GPIO_FN(RXD2),
	GPIO_FN(SCK2),
	GPIO_FN(RTS3),
	GPIO_FN(CTS3),
	GPIO_FN(TXD3),
	GPIO_FN(RXD3),
	GPIO_FN(SCK3),
	GPIO_FN(TXD4),
	GPIO_FN(RXD4),
	GPIO_FN(TXD5),
	GPIO_FN(RXD5),
	GPIO_FN(TXD6),
	GPIO_FN(RXD6),
	GPIO_FN(TXD7),
	GPIO_FN(RXD7),
	GPIO_FN(RTS1),
	GPIO_FN(CTS1),

	/* RSPI */
	GPIO_FN(RSPCK0),
	GPIO_FN(MOSI0),
	GPIO_FN(MISO0_PF12),
	GPIO_FN(MISO1),
	GPIO_FN(SSL00),
	GPIO_FN(RSPCK1),
	GPIO_FN(MOSI1),
	GPIO_FN(MISO1_PG19),
	GPIO_FN(SSL10),

	/* IIC3 */
	GPIO_FN(SCL0),
	GPIO_FN(SCL1),
	GPIO_FN(SCL2),
	GPIO_FN(SDA0),
	GPIO_FN(SDA1),
	GPIO_FN(SDA2),

	/* SSI */
	GPIO_FN(SSISCK0),
	GPIO_FN(SSIWS0),
	GPIO_FN(SSITXD0),
	GPIO_FN(SSIRXD0),
	GPIO_FN(SSIWS1),
	GPIO_FN(SSIWS2),
	GPIO_FN(SSIWS3),
	GPIO_FN(SSISCK1),
	GPIO_FN(SSISCK2),
	GPIO_FN(SSISCK3),
	GPIO_FN(SSIDATA1),
	GPIO_FN(SSIDATA2),
	GPIO_FN(SSIDATA3),
	GPIO_FN(AUDIO_CLK),

	/* SIOF */ /* NOTE Shares AUDIO_CLK with SSI */
	GPIO_FN(SIOFTXD),
	GPIO_FN(SIOFRXD),
	GPIO_FN(SIOFSYNC),
	GPIO_FN(SIOFSCK),

	/* SPDIF */ /* NOTE Shares AUDIO_CLK with SSI */
	GPIO_FN(SPDIF_IN),
	GPIO_FN(SPDIF_OUT),

	/* NANDFMC */ /* NOTE Controller is not available in boot mode 0 */
	GPIO_FN(FCE),
	GPIO_FN(FRB),

	/* VDC3 */
	GPIO_FN(DV_CLK),
	GPIO_FN(DV_VSYNC),
	GPIO_FN(DV_HSYNC),

	GPIO_FN(DV_DATA7),
	GPIO_FN(DV_DATA6),
	GPIO_FN(DV_DATA5),
	GPIO_FN(DV_DATA4),
	GPIO_FN(DV_DATA3),
	GPIO_FN(DV_DATA2),
	GPIO_FN(DV_DATA1),
	GPIO_FN(DV_DATA0),

	GPIO_FN(LCD_CLK),
	GPIO_FN(LCD_EXTCLK),
	GPIO_FN(LCD_VSYNC),
	GPIO_FN(LCD_HSYNC),
	GPIO_FN(LCD_DE),

	GPIO_FN(LCD_DATA15),
	GPIO_FN(LCD_DATA14),
	GPIO_FN(LCD_DATA13),
	GPIO_FN(LCD_DATA12),
	GPIO_FN(LCD_DATA11),
	GPIO_FN(LCD_DATA10),
	GPIO_FN(LCD_DATA9),
	GPIO_FN(LCD_DATA8),
	GPIO_FN(LCD_DATA7),
	GPIO_FN(LCD_DATA6),
	GPIO_FN(LCD_DATA5),
	GPIO_FN(LCD_DATA4),
	GPIO_FN(LCD_DATA3),
	GPIO_FN(LCD_DATA2),
	GPIO_FN(LCD_DATA1),
	GPIO_FN(LCD_DATA0),

	GPIO_FN(LCD_M_DISP),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PAIOR0", 0xfffe3812, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PA3_IN, PA3_OUT,
		PA2_IN, PA2_OUT,
		PA1_IN, PA1_OUT,
		PA0_IN,	PA0_OUT ))
	},

	{ PINMUX_CFG_REG("PBCR5", 0xfffe3824, 16, 4, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PB22MD_00, PB22MD_01, PB22MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PB21MD_0, PB21MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB20MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))

	},
	{ PINMUX_CFG_REG("PBCR4", 0xfffe3826, 16, 4, GROUP(
		0, PB19MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB18MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB17MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB16MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PBCR3", 0xfffe3828, 16, 4, GROUP(
		0, PB15MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB14MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB13MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB12MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PBCR2", 0xfffe382a, 16, 4, GROUP(
		0, PB11MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB10MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB9MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB8MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PBCR1", 0xfffe382c, 16, 4, GROUP(
		0, PB7MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB6MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB5MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB4MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PBCR0", 0xfffe382e, 16, 4, GROUP(
		0, PB3MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB2MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB1MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PBIOR1", 0xfffe3830, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0,
		PB22_IN, PB22_OUT,
		PB21_IN, PB21_OUT,
		PB20_IN, PB20_OUT,
		PB19_IN, PB19_OUT,
		PB18_IN, PB18_OUT,
		PB17_IN, PB17_OUT,
		PB16_IN, PB16_OUT ))
	},

	{ PINMUX_CFG_REG("PBIOR0", 0xfffe3832, 16, 1, GROUP(
		PB15_IN, PB15_OUT,
		PB14_IN, PB14_OUT,
		PB13_IN, PB13_OUT,
		PB12_IN, PB12_OUT,
		PB11_IN, PB11_OUT,
		PB10_IN, PB10_OUT,
		PB9_IN, PB9_OUT,
		PB8_IN, PB8_OUT,
		PB7_IN, PB7_OUT,
		PB6_IN, PB6_OUT,
		PB5_IN, PB5_OUT,
		PB4_IN, PB4_OUT,
		PB3_IN, PB3_OUT,
		PB2_IN, PB2_OUT,
		PB1_IN, PB1_OUT,
		0, 0 ))
	},

	{ PINMUX_CFG_REG("PCCR2", 0xfffe384a, 16, 4, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC10MD_0, PC10MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC9MD_0, PC9MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC8MD_00, PC8MD_01, PC8MD_10, PC8MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PCCR1", 0xfffe384c, 16, 4, GROUP(
		PC7MD_00, PC7MD_01, PC7MD_10, PC7MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC6MD_00, PC6MD_01, PC6MD_10, PC6MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC5MD_00, PC5MD_01, PC5MD_10, PC5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC4MD_0, PC4MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PCCR0", 0xfffe384e, 16, 4, GROUP(
		PC3MD_0, PC3MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC2MD_0, PC2MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC1MD_0, PC1MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PC0MD_0, PC0MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PCIOR0", 0xfffe3852, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		PC10_IN, PC10_OUT,
		PC9_IN, PC9_OUT,
		PC8_IN, PC8_OUT,
		PC7_IN, PC7_OUT,
		PC6_IN, PC6_OUT,
		PC5_IN, PC5_OUT,
		PC4_IN, PC4_OUT,
		PC3_IN, PC3_OUT,
		PC2_IN, PC2_OUT,
		PC1_IN, PC1_OUT,
		PC0_IN, PC0_OUT
	 ))
	},

	{ PINMUX_CFG_REG("PDCR3", 0xfffe3868, 16, 4, GROUP(
		0, PD15MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD14MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD13MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD12MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PDCR2", 0xfffe386a, 16, 4, GROUP(
		0, PD11MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD10MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD9MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD8MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PDCR1", 0xfffe386c, 16, 4, GROUP(
		0, PD7MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD6MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD5MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD4MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PDCR0", 0xfffe386e, 16, 4, GROUP(
		0, PD3MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD2MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD1MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PD0MD_01, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PDIOR0", 0xfffe3872, 16, 1, GROUP(
		PD15_IN, PD15_OUT,
		PD14_IN, PD14_OUT,
		PD13_IN, PD13_OUT,
		PD12_IN, PD12_OUT,
		PD11_IN, PD11_OUT,
		PD10_IN, PD10_OUT,
		PD9_IN, PD9_OUT,
		PD8_IN, PD8_OUT,
		PD7_IN, PD7_OUT,
		PD6_IN, PD6_OUT,
		PD5_IN, PD5_OUT,
		PD4_IN, PD4_OUT,
		PD3_IN, PD3_OUT,
		PD2_IN, PD2_OUT,
		PD1_IN, PD1_OUT,
		PD0_IN, PD0_OUT ))
	},

	{ PINMUX_CFG_REG("PECR1", 0xfffe388c, 16, 4, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PE5MD_00, PE5MD_01, 0, PE5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PE4MD_00, PE4MD_01, 0, PE4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PECR0", 0xfffe388e, 16, 4, GROUP(
		PE3MD_00, PE3MD_01, 0, PE3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PE2MD_00, PE2MD_01, 0, PE2MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PE1MD_000, PE1MD_001, PE1MD_010, PE1MD_011,
		PE1MD_100, PE1MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PE0MD_00, PE0MD_01, PE0MD_10, PE0MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PEIOR0", 0xfffe3892, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0,
		PE5_IN, PE5_OUT,
		PE4_IN, PE4_OUT,
		PE3_IN, PE3_OUT,
		PE2_IN, PE2_OUT,
		PE1_IN, PE1_OUT,
		PE0_IN, PE0_OUT ))
	},

	{ PINMUX_CFG_REG("PFCR3", 0xfffe38a8, 16, 4, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		PF12MD_000, PF12MD_001, 0, PF12MD_011,
		PF12MD_100, PF12MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PFCR2", 0xfffe38aa, 16, 4, GROUP(
		PF11MD_000, PF11MD_001, PF11MD_010, PF11MD_011,
		PF11MD_100, PF11MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF10MD_000, PF10MD_001, PF10MD_010, PF10MD_011,
		PF10MD_100, PF10MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF9MD_000, PF9MD_001, PF9MD_010, PF9MD_011,
		PF9MD_100, PF9MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF8MD_00, PF8MD_01, PF8MD_10, PF8MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PFCR1", 0xfffe38ac, 16, 4, GROUP(
		PF7MD_000, PF7MD_001, PF7MD_010, PF7MD_011,
		PF7MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF6MD_000, PF6MD_001, PF6MD_010, PF6MD_011,
		PF6MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF5MD_000, PF5MD_001, PF5MD_010, PF5MD_011,
		PF5MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF4MD_000, PF4MD_001, PF4MD_010, PF4MD_011,
		PF4MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PFCR0", 0xfffe38ae, 16, 4, GROUP(
		PF3MD_000, PF3MD_001, PF3MD_010, PF3MD_011,
		PF3MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF2MD_000, PF2MD_001, PF2MD_010, PF2MD_011,
		PF2MD_100, PF2MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF1MD_000, PF1MD_001, PF1MD_010, PF1MD_011,
		PF1MD_100, PF1MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PF0MD_000, PF0MD_001, PF0MD_010, PF0MD_011,
		PF0MD_100, PF0MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PFIOR0", 0xfffe38b2, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0,
		PF12_IN, PF12_OUT,
		PF11_IN, PF11_OUT,
		PF10_IN, PF10_OUT,
		PF9_IN, PF9_OUT,
		PF8_IN, PF8_OUT,
		PF7_IN, PF7_OUT,
		PF6_IN, PF6_OUT,
		PF5_IN, PF5_OUT,
		PF4_IN, PF4_OUT,
		PF3_IN, PF3_OUT,
		PF2_IN, PF2_OUT,
		PF1_IN, PF1_OUT,
		PF0_IN, PF0_OUT ))
	},

	{ PINMUX_CFG_REG("PGCR7", 0xfffe38c0, 16, 4, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG0MD_000, PG0MD_001, PG0MD_010, PG0MD_011,
		PG0MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PGCR6", 0xfffe38c2, 16, 4, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG24MD_00, PG24MD_01, PG24MD_10, PG24MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PGCR5", 0xfffe38c4, 16, 4, GROUP(
		PG23MD_00, PG23MD_01, PG23MD_10, PG23MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG22MD_00, PG22MD_01, PG22MD_10, PG22MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG21MD_00, PG21MD_01, PG21MD_10, PG21MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG20MD_000, PG20MD_001, PG20MD_010, PG20MD_011,
		PG20MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PGCR4", 0xfffe38c6, 16, 4, GROUP(
		PG19MD_000, PG19MD_001, PG19MD_010, PG19MD_011,
		PG19MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG18MD_000, PG18MD_001, PG18MD_010, PG18MD_011,
		PG18MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG17MD_000, PG17MD_001, PG17MD_010, PG17MD_011,
		PG17MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG16MD_000, PG16MD_001, PG16MD_010, PG16MD_011,
		PG16MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PGCR3", 0xfffe38c8, 16, 4, GROUP(
		PG15MD_000, PG15MD_001, PG15MD_010, PG15MD_011,
		PG15MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG14MD_000, PG14MD_001, PG14MD_010, 0,
		PG14MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG13MD_000, PG13MD_001, PG13MD_010, 0,
		PG13MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG12MD_000, PG12MD_001, PG12MD_010, 0,
		PG12MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PGCR2", 0xfffe38ca, 16, 4, GROUP(
		PG11MD_000, PG11MD_001, PG11MD_010, PG11MD_011,
		PG11MD_100, PG11MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG10MD_000, PG10MD_001, PG10MD_010, PG10MD_011,
		PG10MD_100, PG10MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG9MD_000, PG9MD_001, PG9MD_010, PG9MD_011,
		PG9MD_100, PG9MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG8MD_000, PG8MD_001, PG8MD_010, PG8MD_011,
		PG8MD_100, PG8MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PGCR1", 0xfffe38cc, 16, 4, GROUP(
		PG7MD_00, PG7MD_01, PG7MD_10, PG7MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG6MD_00, PG6MD_01, PG6MD_10, PG6MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG5MD_00, PG5MD_01, PG5MD_10, PG5MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG4MD_00, PG4MD_01, PG4MD_10, PG4MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PGCR0", 0xfffe38ce, 16, 4, GROUP(
		PG3MD_00, PG3MD_01, PG3MD_10, PG3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG2MD_00, PG2MD_01, PG2MD_10, PG2MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PG1MD_00, PG1MD_01, PG1MD_10, PG1MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PGIOR1", 0xfffe38d0, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0,
		PG24_IN, PG24_OUT,
		PG23_IN, PG23_OUT,
		PG22_IN, PG22_OUT,
		PG21_IN, PG21_OUT,
		PG20_IN, PG20_OUT,
		PG19_IN, PG19_OUT,
		PG18_IN, PG18_OUT,
		PG17_IN, PG17_OUT,
		PG16_IN, PG16_OUT ))
	},

	{ PINMUX_CFG_REG("PGIOR0", 0xfffe38d2, 16, 1, GROUP(
		PG15_IN, PG15_OUT,
		PG14_IN, PG14_OUT,
		PG13_IN, PG13_OUT,
		PG12_IN, PG12_OUT,
		PG11_IN, PG11_OUT,
		PG10_IN, PG10_OUT,
		PG9_IN, PG9_OUT,
		PG8_IN, PG8_OUT,
		PG7_IN, PG7_OUT,
		PG6_IN, PG6_OUT,
		PG5_IN, PG5_OUT,
		PG4_IN, PG4_OUT,
		PG3_IN, PG3_OUT,
		PG2_IN, PG2_OUT,
		PG1_IN, PG1_OUT,
		PG0_IN, PG0_OUT
	 ))
	},

	{ PINMUX_CFG_REG("PHCR1", 0xfffe38ec, 16, 4, GROUP(
		PH7MD_0, PH7MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PH6MD_0, PH6MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PH5MD_0, PH5MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PH4MD_0, PH4MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PHCR0", 0xfffe38ee, 16, 4, GROUP(
		PH3MD_0, PH3MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PH2MD_0, PH2MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PH1MD_0, PH1MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PH0MD_0, PH0MD_1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PJCR2", 0xfffe390a, 16, 4, GROUP(
		PJ11MD_00, PJ11MD_01, PJ11MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ10MD_00, PJ10MD_01, PJ10MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ9MD_00, PJ9MD_01, PJ9MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ8MD_00, PJ8MD_01, PJ8MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PJCR1", 0xfffe390c, 16, 4, GROUP(
		PJ7MD_00, PJ7MD_01, PJ7MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ6MD_00, PJ6MD_01, PJ6MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ5MD_00, PJ5MD_01, PJ5MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ4MD_00, PJ4MD_01, PJ4MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PJCR0", 0xfffe390e, 16, 4, GROUP(
		PJ3MD_00, PJ3MD_01, PJ3MD_10, PJ3MD_11, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ2MD_000, PJ2MD_001, PJ2MD_010, PJ2MD_011,
		PJ2MD_100, PJ2MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ1MD_000, PJ1MD_001, PJ1MD_010, PJ1MD_011,
		PJ1MD_100, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ0MD_000, PJ0MD_001, PJ0MD_010, PJ0MD_011,
		PJ0MD_100, PJ0MD_101, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, ))
	},
	{ PINMUX_CFG_REG("PJIOR0", 0xfffe3912, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		PJ11_IN, PJ11_OUT,
		PJ10_IN, PJ10_OUT,
		PJ9_IN, PJ9_OUT,
		PJ8_IN, PJ8_OUT,
		PJ7_IN, PJ7_OUT,
		PJ6_IN, PJ6_OUT,
		PJ5_IN, PJ5_OUT,
		PJ4_IN, PJ4_OUT,
		PJ3_IN, PJ3_OUT,
		PJ2_IN, PJ2_OUT,
		PJ1_IN, PJ1_OUT,
		PJ0_IN, PJ0_OUT ))
	},

	{ PINMUX_CFG_REG("PKCR2", 0xfffe392a, 16, 4, GROUP(
		PK11MD_00, PK11MD_01, PK11MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK10MD_00, PK10MD_01, PK10MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK9MD_00, PK9MD_01, PK9MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK8MD_00, PK8MD_01, PK8MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PKCR1", 0xfffe392c, 16, 4, GROUP(
		PK7MD_00, PK7MD_01, PK7MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK6MD_00, PK6MD_01, PK6MD_10, 0,  0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK5MD_00, PK5MD_01, PK5MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK4MD_00, PK4MD_01, PK4MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PKCR0", 0xfffe392e, 16, 4, GROUP(
		PK3MD_00, PK3MD_01, PK3MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK2MD_00, PK2MD_01, PK2MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK1MD_00, PK1MD_01, PK1MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		PK0MD_00, PK0MD_01, PK0MD_10, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0 ))
	},

	{ PINMUX_CFG_REG("PKIOR0", 0xfffe3932, 16, 1, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		PK11_IN, PK11_OUT,
		PK10_IN, PK10_OUT,
		PK9_IN, PK9_OUT,
		PK8_IN, PK8_OUT,
		PK7_IN, PK7_OUT,
		PK6_IN, PK6_OUT,
		PK5_IN, PK5_OUT,
		PK4_IN, PK4_OUT,
		PK3_IN, PK3_OUT,
		PK2_IN, PK2_OUT,
		PK1_IN, PK1_OUT,
		PK0_IN, PK0_OUT ))
	},
	{}
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR1", 0xfffe3814, 16, GROUP(
		0, 0, 0, 0, 0, 0, 0, PA3_DATA,
		0, 0, 0, 0, 0, 0, 0, PA2_DATA ))
	},

	{ PINMUX_DATA_REG("PADR0", 0xfffe3816, 16, GROUP(
		0, 0, 0, 0, 0, 0, 0, PA1_DATA,
		0, 0, 0, 0, 0, 0, 0, PA0_DATA ))
	},

	{ PINMUX_DATA_REG("PBDR1", 0xfffe3834, 16, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, PB22_DATA, PB21_DATA, PB20_DATA,
		PB19_DATA, PB18_DATA, PB17_DATA, PB16_DATA ))
	},

	{ PINMUX_DATA_REG("PBDR0", 0xfffe3836, 16, GROUP(
		PB15_DATA, PB14_DATA, PB13_DATA, PB12_DATA,
		PB11_DATA, PB10_DATA, PB9_DATA, PB8_DATA,
		PB7_DATA, PB6_DATA, PB5_DATA, PB4_DATA,
		PB3_DATA, PB2_DATA, PB1_DATA, 0 ))
	},

	{ PINMUX_DATA_REG("PCDR0", 0xfffe3856, 16, GROUP(
		0, 0, 0, 0,
		0, PC10_DATA, PC9_DATA, PC8_DATA,
		PC7_DATA, PC6_DATA, PC5_DATA, PC4_DATA,
		PC3_DATA, PC2_DATA, PC1_DATA, PC0_DATA ))
	},

	{ PINMUX_DATA_REG("PDDR0", 0xfffe3876, 16, GROUP(
		PD15_DATA, PD14_DATA, PD13_DATA, PD12_DATA,
		PD11_DATA, PD10_DATA, PD9_DATA, PD8_DATA,
		PD7_DATA, PD6_DATA, PD5_DATA, PD4_DATA,
		PD3_DATA, PD2_DATA, PD1_DATA, PD0_DATA ))
	},

	{ PINMUX_DATA_REG("PEDR0", 0xfffe3896, 16, GROUP(
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, PE5_DATA, PE4_DATA,
		PE3_DATA, PE2_DATA, PE1_DATA, PE0_DATA ))
	},

	{ PINMUX_DATA_REG("PFDR0", 0xfffe38b6, 16, GROUP(
		0, 0, 0, PF12_DATA,
		PF11_DATA, PF10_DATA, PF9_DATA, PF8_DATA,
		PF7_DATA, PF6_DATA, PF5_DATA, PF4_DATA,
		PF3_DATA, PF2_DATA, PF1_DATA, PF0_DATA ))
	},

	{ PINMUX_DATA_REG("PGDR1", 0xfffe38d4, 16, GROUP(
		0, 0, 0, 0, 0, 0, 0, PG24_DATA,
		PG23_DATA, PG22_DATA, PG21_DATA, PG20_DATA,
		PG19_DATA, PG18_DATA, PG17_DATA, PG16_DATA ))
	},

	{ PINMUX_DATA_REG("PGDR0", 0xfffe38d6, 16, GROUP(
		PG15_DATA, PG14_DATA, PG13_DATA, PG12_DATA,
		PG11_DATA, PG10_DATA, PG9_DATA, PG8_DATA,
		PG7_DATA, PG6_DATA, PG5_DATA, PG4_DATA,
		PG3_DATA, PG2_DATA, PG1_DATA, PG0_DATA ))
	},
	{ PINMUX_DATA_REG("PJDR0", 0xfffe3916, 16, GROUP(
		0, 0, 0, PJ12_DATA,
		PJ11_DATA, PJ10_DATA, PJ9_DATA, PJ8_DATA,
		PJ7_DATA, PJ6_DATA, PJ5_DATA, PJ4_DATA,
		PJ3_DATA, PJ2_DATA, PJ1_DATA, PJ0_DATA ))
	},
	{ PINMUX_DATA_REG("PKDR0", 0xfffe3936, 16, GROUP(
		0, 0, 0, PK12_DATA,
		PK11_DATA, PK10_DATA, PK9_DATA, PK8_DATA,
		PK7_DATA, PK6_DATA, PK5_DATA, PK4_DATA,
		PK3_DATA, PK2_DATA, PK1_DATA, PK0_DATA ))
	},
	{ }
};

const struct sh_pfc_soc_info sh7264_pinmux_info = {
	.name = "sh7264_pfc",
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END, FORCE_IN },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END, FORCE_OUT },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.func_gpios = pinmux_func_gpios,
	.nr_func_gpios = ARRAY_SIZE(pinmux_func_gpios),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
